FUNCTION_BLOCK FB_registers_display_sync
VAR_INPUT
PointNR									: USINT ;
END_VAR

VAR
iTemp, iURV								: INT 	;
regTemp									: WORD ;
register_PointValue						: REAL ;
display_Pointvalue						: REAL ;
END_VAR
display_Pointvalue	:= GetDisplayPointValueF (PointNR, DisplayAddress, ProgramValues[PointNR]) ;						(* read display value *)

regTemp 			:= GetRegisterF(USINT_TO_UINT(PointNR)) ;															(* read register value *)
iTemp 				:= WORD_TO_INT (regTemp) ;																			(* convert to int *)
register_PointValue	:= INT_TO_REAL (iTemp) ;																			(* convert to real *)

IF display_Pointvalue<>ProgramValues[PointNR] THEN																		(* if the display has been updated last *)
	ProgramValues[PointNR] := display_Pointvalue ;																		(* save the new value from the display to the program *)
	iTemp	:= REAL_TO_INT(display_Pointvalue) ;
	iURV := SetRegisterF (USINT_TO_UINT(PointNR), INT_TO_WORD(iTemp));													(* save the new display value to the register *)
ELSIF (register_PointValue<>ProgramValues[PointNR]) THEN																(* if register value was changed (remotely) *)
	ProgramValues[PointNR] := register_PointValue ;																		(* save the new value from the register into the program *)
	display_Pointvalue := register_PointValue ;																			(* and prepare it to be written to the display also *)
END_IF ;

iURV := SetDisplayPointValueF (PointNR, DisplayAddress, REAL_TO_DINT(display_Pointvalue));								(* write the (possibly) new value to the display *)
END_FUNCTION_BLOCK